DROP PROCEDURE [hips].[StreetSuffixTypeCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the StreetSuffixType Code Table
-- =============================================
CREATE PROCEDURE [hips].[StreetSuffixTypeCodeGet] 
(
	@CodeSystemCode VARCHAR,
	@StreetSuffixTypeId INT = NULL
)
AS
BEGIN

	SELECT  sst.StreetSuffixTypeId, sst.Code, sst.Description
	FROM    hips.StreetSuffixTypeCode sstc
			JOIN hips.StreetSuffixType sst ON sstc.StreetSuffixTypeId = sst.StreetSuffixTypeId
			JOIN hips.CodeSystem cs ON sstc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND sst.StreetSuffixTypeId = @StreetSuffixTypeId OR @StreetSuffixTypeId IS NULL
	ORDER BY sst.Description

END
GO

